"use client";

import { Barlow } from "next/font/google";
import GetInTouch from "../common/GetInTouch";

const barlow = Barlow({
  subsets: ["latin"],
  weight: ["400", "500", "600"],
  display: "swap",
});

const MapWithOverlay = () => {
  return (
    <div
      className={`w-full h-auto mt-20 flex flex-col items-center justify-end bg-white relative ${barlow.className}`}
    >
      <GetInTouch />

      <iframe
        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3321.7145919862164!2d-117.73668092378112!3d33.63864153945563!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80dce80b26395bad%3A0xd85905946adf1e33!2s9245%20Research%20Dr%2C%20Irvine%2C%20CA%2092618%2C%20Amerika%20Birle%C5%9Fik%20Devletleri!5e0!3m2!1str!2str!4v1755239429900!5m2!1str!2str"
        className="w-full h-[50vh] sm:h-[60vh] filter grayscale z-0"
        style={{ border: 0 }}
        allowFullScreen
        loading="lazy"
        referrerPolicy="no-referrer-when-downgrade"
      />
    </div>
  );
};

export default MapWithOverlay;
